
/**
 ******************************************************************************
 *
 * @file        Utils.h
 * @brief       utils headfile.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef __UTILS_H_
#define __UTILS_H_

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
#ifndef min
# define min(a,b) ( ((a) < (b)) ? (a) : (b) )
#endif
#ifndef max
# define max(a,b) ( ((a) > (b)) ? (a) : (b) )
#endif
#ifndef clamp
#  define clamp(x, min, max) ( ((x) < (min)) ? (min) : ( ((x) > (max)) ? (max) : (x) ) )
#endif
#ifndef testBits
#  define testBits(x, bits) ( ((x) & (bits)) == (bits) )
#endif

#ifdef UTILS_DEBUG
#define UTILS_DEBUG_OUT(format, ...) printf("%s:%d: " format, __FILE__, __LINE__, ##__VA_ARGS__)
#else
#define UTILS_DEBUG_OUT(format, ...)
#endif

#ifndef SWAP_UINT16
#  define SWAP_UINT16(x) (((x) >> 8) | ((x) << 8))
#endif
#ifndef SWAP_UINT32
#  define SWAP_UINT32(x) (((x) >> 24) | (((x) & 0x00FF0000) >> 8) | (((x) & 0x0000FF00) << 8) | ((x) << 24))
#endif

/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
uint32_t swapEndian(uint32_t val);
void strTrim(char* str);
void strTrimLeft(char* str);
void strTrimRight(char* str);
int isWhitespace(char ch);
char* urlDecode(char* str);
void printMemory(uint8_t* buffer, uint32_t length);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

//#define returnNonOKHALStatus(fn) {  \
//  HAL_StatusTypeDef status = fn;    \
//  if (status != HAL_OK) {           \
//    return status;                  \
//  }                                 \
//}

//#define assertNonOKHALStatus(fn) {  \
//  HAL_StatusTypeDef status = fn;    \
//  if (status != HAL_OK) {           \
//    UTILS_DEBUG_OUT("assert %d\n", status); \
//    while(1);                       \
//  }                                 \
//}

#endif

